;
; simple soccer tactics, 0.07
;
; basic tactics and ball - 30 Apr 2002
; with replay ability (ball) - 23 Jun 2002
; with replay ability (players) - 08 Feb 2003
;
; by Matt Sephton (matt@ewtoo.org)
;

HidePointer

Global filename$

;init
Dim inputarray(370)
Dim tactics(10,35,2)	;players,segments,x/y

Type filedetails
	Field name$
	Field num
End Type

Type coord
	Field x,y
	Field inplay		;special
End Type

Type replay_coord
	Field x,y
	Field inplay
End Type

Type player
	Field x#,y#			;current x,y
	Field tx#,ty#		;target x,y
	Field dx#,dy#		;movement x,y
End Type

For p = 0 To 9
	team.player = New player
Next

AppTitle "Select a Tactics file"

;draw
Global W = 540, H = 644
Global GW = W/5, GH = H/7
Global M = 3
Global R = 2	;4

;Graphics W,H,16,2
Graphics 1024,768
;Graphics 800,600
SetBuffer BackBuffer()
Origin (1024-W)/2, (768-H)/2
;Origin (800-W)/2, (600-H)/2

load_tactics()

Global replay_counter = 0
Global playback_pointer = 0
Global replay_mode = False

Gosub init_players

ball.coord = New coord
ball\x = W/2
ball\y = H/2
ball\inplay = False	;True

Const target_fps = 24			;so we can reuse this constant
Const total_objects = 11		;total number of objects to track
Global replay_length = 5		;seconds

Global max_buffer_size = total_objects * target_fps * replay_length

Global grid = True

AppTitle "Simple Soccer - Tactics " + filename$
;Graphics W,H,16,2
;SetBuffer BackBuffer()

mainfps = CreateTimer(target_fps)

ClsColor 33,99,0
While Not KeyHit(1)
	Cls
	Color 128,128,128
	Text 0,(GH/2)-18,"Tactics v0.07"
	Text 0,(GH/2)-6,"Simple Soccer"
	Text 8,(GH/2)+6,"08-Feb-2003"
	
	Text 16,GH-18,"R["+ replay_length +"]=" +replay_counter
	
	If KeyHit(34) Then grid = Not grid
	
	If (grid = True) Then
		For yc = 0 To 6
			For xc = 0 To 4
				Color 128,128,128
				Text (xc * GW),(yc * GH),(yc*5)+(xc)
				;Color 255,255,255
				Rect (xc * GW)-1, (yc * GH)-1, GW+1,GH+1, False
			Next
		Next
	EndIf
	
	draw_pitch()

	If (replay_mode = False) Then

		ball\x = ball\x - (M*KeyDown(203)) + (M*KeyDown(205))
		ball\y = ball\y - (M*KeyDown(200)) + (M*KeyDown(208))

		R = R - KeyHit(26) + KeyHit(27)
		If (R < 1) Then R = 1
		If (R > 5) Then R = 5

		;increase/decrease buffer size, P and O
		If KeyHit(25) Then
			replay_length = replay_length + 1	;increase
			If (replay_length > 9) Then replay_length = 9

			max_buffer_size = total_objects * target_fps * replay_length
		Else If KeyHit(24) Then
			replay_length = replay_length - 1	;decrease
			If (replay_length < 3) Then replay_length = 3
			
			max_buffer_size = total_objects * target_fps * replay_length
		EndIf

		If KeyHit(57) Then	;space
			ball\x = Rand(0,W)
			ball\y = Rand(0,H)
		EndIf
	
		If KeyDown(15) Then	;tab
			count = 0
			where = (ball\x / GW) + (ball\y / GH)*5
			For team.player = Each player
				team\tx = W + ((count+1) * (W/20))
				team\ty = H/2
				team\x = team\tx
				team\y = team\ty
				count = count + 1
			Next
			ball\x = W/2
			ball\y = H/2
			ball\inplay = True
		EndIf

		;overflow, limit replay data to max_buffer_size by deleting oldest data item
		While (replay_counter >= max_buffer_size)
			For d = 1 To total_objects
				Delete First replay_coord
			Next
			replay_counter = replay_counter - total_objects		;less data used
		Wend

		;ball
		replay.replay_coord = New replay_coord
		replay\x = ball\x
		replay\y = ball\y
		replay\inplay = ball\inplay
		replay_counter = replay_counter + 1

		;team
		For team.player = Each player
			replay.replay_coord = New replay_coord
			replay\x = team\x
			replay\y = team\y
			replay\inplay = False
			replay_counter = replay_counter + 1
		Next
		
		;R = replay mode
		If KeyDown(19) Then replay_mode = True
		
	Else

		Color 255,255,255

		Text W/2,(H/2)-20, "REPLAY PLAYBACK",True
		Text W/2,(H/2)+10, playback_pointer + "/" + replay_counter, True
		
		slowmo = KeyDown(19) And (Not KeyDown(33))	;R not F
	
		If (slowmo = True) Then Delay 75	;slow motion replay!

		If (playback_pointer = 0) Then rd.replay_coord = First replay_coord	;rd = start of replay collection

		;draw replay cursor
		;If (playback_pointer Mod target_fps > target_fps/2) Then Text W-20,10,"R"
		
		If (playback_pointer < replay_counter) Then			;still in replay data
			;set player draw position to be replay data
			ball\x = rd\x
			ball\y = rd\y
			rd = After rd			;go to next replay data item in collection
			playback_pointer = playback_pointer + 1

			Color 255,0,0
			count = 0
			For team.player = Each player
				team\x = rd\x
				team\y = rd\y
				rd = After rd							;go to next replay data item in collection
				playback_pointer = playback_pointer + 1	;move forward through replay data

				Oval team\x-3, team\y-3, 7,7, True
				Text team\x+1,team\y+1, count
				count = count + 1
			Next

		Else 												;end of the replay data
			playback_pointer = 0	;rewind pointer to beginning of replay data
			replay_mode = False		;turn off replay
			;slowmo = False			;normal speed
		EndIf
		
	EndIf

	If GetKey() Then ball\inplay = False

	Color 255,255,0	;255
	Oval ball\x-3, ball\y-3, 7,7, True
	Text ball\x+1,ball\y+1,"B"

	where = (ball\x / GW) + (ball\y / GH)*5
	If (where > 34) Then where = 34

	Color 255,0,0

	If (replay_mode = False) Then

		count = 0
		For team.player = Each player
			If (ball\inplay = True) Then
				team\tx = (W/2) + (count * 20) + 20
				team\ty = (H/2) - (50-(count*4))
			Else
				team\tx = tactics(count,where,0) * (W/14)
				team\ty = tactics(count,where,1) * (H/15)
			EndIf
	
			dt# = ATan2(team\ty - team\y, team\tx - team\x)
			
			team\dx = Cos(dt) * R
			team\dy = Sin(dt) * R
	
			If (near(team\x,team\tx,4) And near(team\y,team\ty,4)) Then
				team\x = team\tx
				team\y = team\ty
				team\dx = 0
				team\dy = 0
			EndIf
	
			If (team\x > W) Then
				team\x = team\x - R
			Else
				team\x = team\x + team\dx
				team\y = team\y + team\dy
			EndIf
	
			If (team\dx Or team\dy) Then Line team\x,team\y,team\x+(5*team\dx),team\y+(5*team\dy)
			Oval team\x-3, team\y-3, 7,7, True
			Text team\x+1,team\y+1, count
			count = count+1
		Next

	EndIf

	Text GW/2,0,"R="+R,True

	Text GW/2,H-20,"GRID="+grid,True

	;limit drawing speed
	If (replay_mode = True) Then
		If (Not KeyDown(33)) Then k = WaitTimer(mainfps)	;F = f/fwd replay
	Else
		k = WaitTimer(mainfps)
	EndIf

	Flip
Wend

;free memeory used for replay buffer
For free.replay_coord = Each replay_coord
	Delete free
Next

FreeTimer(fps)
ShowPointer
End

;
.init_players
	count = 0
	For team.player = Each player
		;team\tx = tactics(count,19,0) * (W/14)
		;team\ty = tactics(count,19,1) * (H/15)
		;team\x = team\tx
		;team\y = team\ty
		team\x = W + ((count+1) * (W/20))
		team\y = H/2
		count = count + 1
	Next
Return

Function draw_pitch()
	;WHITE
	Color 255,255,255

	;pen circs
	Oval GW*2.5-GW/2,GH*0.65-GH/2,GW-1,GH,False	;top
	Oval GW*2.5-GW/2,H-GH*0.65-GH/2,GW-1,GH,False	;btm

	;GREEN
	Color 33,99,0
	Rect GW*2,0,GW-1,GH-1,True
	Rect GW*2,H-GH,GW-1,GH-1,True

	;WHITE
	Color 255,255,255

	;boundary
	Rect 0,0,W,H,False

	;centre
	Line 0,H/2,W,H/2
	Oval (W/2)-(GW/2),(H/2)-(GH/2),GW,GH,False
	Rect W/2-1,H/2-1,3,3

	;box 1
	Line GW,0,GW,GH-2
	Line GW*4-2,0,GW*4-2,GH-2
	Line GW,GH-2,GW*4-2,GH-2
	;pen 1
	Line GW*2,0,GW*2,GH*0.3
	Line GW*3-2,0,GW*3-2,GH*0.3
	Line GW*2,GH*0.3,GW*3-2,GH*0.3
	Rect GW*2.5-2,GH*0.65-1,3,3

	;box 2
	Line GW,H-1,GW,H-GH
	Line GW*4-2,H-1,GW*4-2,H-GH
	Line GW,H-GH,GW*4-2,H-GH
	;pen 2
	Line GW*2,H-1,GW*2,H-1-GH*0.3
	Line GW*3-2,H-1,GW*3-2,H-1-GH*0.3
	Line GW*2,H-1-GH*0.3,GW*3-2,H-1-GH*0.3
	Rect GW*2.5-2,H-1-GH*0.65-1,3,3

	;corners
	Oval -14,-14,28,28,False
	Oval W-14,-14,28,28,False
	Oval -14,H-14,28,28,False
	Oval W-14,H-14,28,28,False

	;GREEN
	Color 33,99,0
	
	;sidelines
	Rect -14,-14,W+28,14,True	;top
	Rect -14,H,W+28,H-14,True	;btm
	Rect -14,0,14,H+28,True		;left
	Rect W,0,14,H+28,True		;right

End Function

Function load_tactics()
	folder$ = ".\data\"
	myDir = ReadDir(folder$)
	
	fcount = 0
	Repeat
		file$ = NextFile$(myDir)
		
		If file$="" Then Exit
		
		If (FileType(folder$+file$) = 1) And (Upper(file$) <> "DEFAULT.TAC") Then
			tac.filedetails = New filedetails
			tac\name = Upper(Left$(file$,Instr(Lower$(file$),".tac")-1))
			tac\num = fcount
			fcount = fcount + 1
		End If
	Forever
	
	fps = CreateTimer(10)
	
	pos = 0
	Repeat
		Cls
	
		;Locate 0,0
		c = 0
		For f.filedetails = Each filedetails
			If (pos = c) Then
				Color 255,0,0
			Else
				Color 255,255,255
			EndIf
			If (c = pos) Then
				Text W/2,H/3+(c*12)-(pos*12), " SELECT  [      ]  TACTICS",True
			EndIf
			Text W/2,H/3+(c*12)-(pos*12), f\name,True
			c = c + 1
		Next
		
		pos = pos - KeyDown(200) + KeyDown(208)
		If (pos < 0) Then pos = 0
		If (pos > fcount -1) Then pos = fcount -1
		
		If KeyDown(1) Then
			pos = -1
			Exit
		EndIf
		
		If KeyHit(28) Then Exit

		k = WaitTimer(fps)
		
		Flip()
	Forever
	
	CloseDir myDir
	
	c = 0
	For f.filedetails = Each filedetails
		If (c = pos) Then filename$ = f\name
		c = c + 1
	Next

	If (pos = -1) Then filename$ = "DEFAULT"

	;read tactics
	din = ReadFile(folder$ + filename$ + ".tac")
	If (din = 0) Then End ;RuntimeError("FILE")
		For i = 0 To 369
			inputarray(i) = ReadByte(din)
		Next
	CloseFile(din)
	
	;translate
	For i = 0 To 9
		For j = 0 To 34
			intvalue = inputarray( (i*35)+j+9 )
			vertint = intvalue And 15
			horizint = intvalue Shr 4
			tactics(i,j,0) = horizint
			tactics(i,j,1) = vertint
		Next
	Next
	
	FlushKeys()
End Function

Function near(a,b,dist)
	Return (a>b-dist And a<b+dist)
End Function

;