Attribute VB_Name = "modBMP"
Option Explicit

Public Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Public Type PALETTEENTRY
    peBlue As Byte
    peGreen As Byte
    peRed As Byte
    peFlags As Byte
End Type

Public Type LOGPALETTE
    palVersion As Integer
    palNumEntries As Integer
    palPalEntry() As PALETTEENTRY
End Type


Public Type MSPALETTEENTRY '//Microsoft palette entry is reverse of normal. example rgb, insteed of bgr
    peRed As Byte
    peGreen As Byte
    peBlue As Byte
    peFlags As Byte
End Type

Public Type MSLOGPALETTE
    palVersion As Integer
    palNumEntries As Integer
    palPalEntry(0 To 255) As MSPALETTEENTRY
End Type


Public Type BITMAPFILEHEADER '14 bytes
        bfType As Integer
        bfSize As Long
        bfReserved1 As Integer
        bfReserved2 As Integer
        bfOffBits As Long
End Type

Public Type BITMAPINFOHEADER '40 bytes
        biSize As Long
        biWidth As Long
        biHeight As Long
        biPlanes As Integer
        biBitCount As Integer
        biCompression As Long
        biSizeImage As Long
        biXPelsPerMeter As Long
        biYPelsPerMeter As Long
        biClrUsed As Long
        biClrImportant As Long
End Type

Public Type BITMAPINFO_8
   bmiHeader As BITMAPINFOHEADER
   bmiColors(0 To 255) As PALETTEENTRY
End Type

Public Type BITMAP
    bmType As Long
    bmWidth As Long
    bmHeight As Long
    bmWidthBytes As Long
    bmPlanes As Integer
    bmBitsPixel As Integer
    bmBits As Long
End Type


Public Declare Function Rectangle Lib "gdi32" (ByVal hdc As Long, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Public Declare Function CreatePen Lib "gdi32" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long

Public Declare Function SetPixelV Lib "gdi32.dll" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long
Public Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Public Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Public Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Public Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Public Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Public Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Public Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function SetDIBits Lib "gdi32" (ByVal aHDC As Long, ByVal hBitmap As Long, ByVal nStartScan As Long, ByVal nNumScans As Long, lpBits As Any, lpBI As BITMAPINFO_8, ByVal wUsage As Long) As Long
Public Declare Function StretchDIBits Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal dx As Long, ByVal dy As Long, ByVal SrcX As Long, ByVal SrcY As Long, ByVal wSrcWidth As Long, ByVal wSrcHeight As Long, lpBits As Any, lpBitsInfo As BITMAPINFO_8, ByVal wUsage As Long, ByVal dwRop As Long) As Long

Public Const DIB_RGB_COLORS As Long = 0
Public Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long

Public Declare Function GetTickCount Lib "kernel32" () As Long

Private FileHeader As BITMAPFILEHEADER
Private InfoHeader As BITMAPINFOHEADER
Private BmPalette As LOGPALETTE
Private bData() As Byte
Private MSPalette As MSLOGPALETTE
Private Opened As Boolean
Private ohDC As Long
Private mWidth As Long
Private mHeight As Long
Private mBytes() As Byte

Public Sub LoadBMP(picout As PictureBox, lpzFile As String, kStyle As Byte, mKit As Long, sKit As Long, shrt As Long, shck As Long, Optional transIndex As Long = -1)
Dim cX As Long, cY As Long
Dim colX As Long
Dim transCol As Long
Dim colArray() As Long
Dim ScreenDC As Long
Dim RetVal As Long '//Just a value to check if the setdibits routine is successful.
Dim picbmp As Long '// These are the tmp DCs which will be deleted at the end of this routine.
Dim ks As Integer
'//This method loads a bitmap picture by setting the approximate color, pixel by pixel.
'//It's about 10 times slower than the previous method which uses the setdibits api call.

'//If you want to load Different palette
'Open "D:\VB_Projects\Mugen_Fighter_Clone_Projects" & "\DarkBlue.pal" For Binary Access Read As #1
'ReDim MSPalette.palPalEntry(255) '//Resize palette to fit to picture palette
'Get #1, 25, MSPalette.palPalEntry()
'Close #1
'//
        
If Opened = False Then

Open lpzFile For Binary Access Read As #1
  
Get #1, , FileHeader 'Get File Header
Get #1, , InfoHeader 'Get Info Header

'//CreatePalette
ReDim BmPalette.palPalEntry(InfoHeader.biClrUsed - 1) '//Resize palette to fit to picture palette
Get #1, , BmPalette.palPalEntry()
'// End Palette

ReDim bData(FileHeader.bfSize - FileHeader.bfOffBits)
Get #1, FileHeader.bfOffBits + 1, bData()

Close #1

End If

Opened = True

            If transIndex <> -1 Then
            With BmPalette.palPalEntry(transIndex)
                transCol = RGB(.peRed, .peGreen, .peBlue)
            End With
            End If
        
        '//Create the memory bitmap
        ScreenDC = GetDC(picout.hwnd)
    
        ohDC = CreateCompatibleDC(ScreenDC)

   
        picbmp = CreateCompatibleBitmap(ScreenDC, InfoHeader.biWidth, InfoHeader.biHeight)


        SelectObject ohDC, picbmp
        
        RetVal = ReleaseDC(picout.hwnd, ScreenDC)
    
        DeleteObject picbmp
        
        '//
        
Dim cp As Long '//Which byte number should get
ReDim colArray(InfoHeader.biWidth - 1, InfoHeader.biHeight - 1)
       For cY = InfoHeader.biHeight - 1 To 0 Step -1
        For cX = 0 To InfoHeader.biWidth - 1
                      
            With BmPalette.palPalEntry(bData(cp))
                colX = RGB(.peRed, .peGreen, .peBlue)
            End With
            
            'If colX <> transCol Then _
            SetPixelV ohDC, cX, cY, colX
            
            SetPixelV ohDC, cX, cY, colX
            
            If kStyle = 0 Then
            
            If colX = RGB(255, 0, 0) Then _
            SetPixelV ohDC, cX, cY, mKit
            
            If colX = RGB(0, 0, 255) Then _
            SetPixelV ohDC, cX, cY, mKit
            
            ElseIf kStyle = 2 Then
            
            If colX = RGB(255, 0, 0) Then _
            SetPixelV ohDC, cX, cY, mKit
            
            If colX = RGB(0, 0, 255) Then _
            SetPixelV ohDC, cX, cY, sKit
            
            ElseIf kStyle = 1 Then
            
            If colX = RGB(0, 0, 255) Then _
            SetPixelV ohDC, cX, cY, mKit
            
            If colX = RGB(255, 0, 0) Then _
            SetPixelV ohDC, cX, cY, sKit
            
            ElseIf kStyle = 3 Then
            
            If colX = RGB(0, 0, 255) Then _
            SetPixelV ohDC, cX, cY, mKit
            
            If colX = RGB(255, 0, 0) Then _
            SetPixelV ohDC, cX, cY, sKit
            
            End If
            
            If colX = RGB(51, 136, 0) Then _
            SetPixelV ohDC, cX, cY, shrt
            
            If colX = RGB(255, 255, 0) Then _
            SetPixelV ohDC, cX, cY, shck
            
            cp = cp + 1 '//Go to next byte
            
        Next cX
        
        cp = cp + 3 '// At the end of each image line there are 3 bytes of zero. So Skip them
        
    Next cY
    If kStyle = 0 Then
        ks = 0
    Else
        ks = kStyle - 1
    End If
    BitBlt picout.hdc, 0, 0, 27, 36, ohDC, (ks) * 27, 0, vbSrcCopy
    
    picout.Refresh
    
    DeleteDC ohDC '//Removes all DCs from memory.
    ohDC = 0

End Sub

